//
// KeepItCleanMessage Unreal Tournament Message
// Version: 1.0
// Author: Boden Maddox (idea by IceTed)
// UT Version Coded/Tested: 4.28
//

class KeepItCleanMessage expands LocalMessagePlus;

var(KeepItClean) localized string KICIP;
var(KeepItClean) localized string KICNextIP;
var(KeepItClean) localized string KICWarnIP;

var color YellowColor;

static function color GetColor(
	optional int Switch,
	optional PlayerReplicationInfo RelatedPRI_1,
	optional PlayerReplicationInfo RelatedPRI_2
	)
{
	return Default.YellowColor;
}

static function float GetOffset(int Switch, float YL, float ClipY )
{
	return ClipY - YL*8 - 0.0833*ClipY;
}

static function string GetString(optional int Switch, optional PlayerReplicationInfo RelatedPRI_1, optional PlayerReplicationInfo RelatedPRI_2, optional Object OptionalObject)
{
	switch (Switch)
	{
		case 0:
			return Default.KICIP;
			break;
		case 1:
			return Default.KICNextIP;
			break;
		case 2:
			return Default.KICWarnIP;
			break;
	}
	return "";
}

//static simulated function ClientReceive(PlayerPawn P, optional int Switch, optional PlayerReplicationInfo RelatedPRI_1, optional PlayerReplicationInfo RelatedPRI_2, optional Object OptionalObject)
//{
//	Super.ClientReceive(P, Switch, RelatedPRI_1, RelatedPRI_2, OptionalObject);
//}

defaultproperties
{
	bHidden=True
}